
"use strict";
// Class definition

var KTAppsUsersListDatatable = function() {
	// Private functions
   //var dataJSONArray = JSON.parse();
		//console.log(dataJSONArray);
	// basic demo
	var _demo = function() {
		//console.log($('#client_id').val());
		var datatable = $('#kt_datatable').KTDatatable({
			
			// datasource definition
			data: {
				type: 'remote',
				//source: dataJSONArray,
				source: {
					read: {
						
						url: "ajax/client_orders_ajax.php",
						method: 'POST',
						params: {						
							client_id: $('#client_id').val(),							
						}

					},
				},

				pageSize: 10, // display 20 records per page
				serverPaging: true,
				//serverFiltering: true,
				//serverSorting: true,
			},
	
			// layout definition
			layout: {
				scroll: false, // enable/disable datatable scroll both horizontal and vertical when needed.
				footer: false, // display/hide footer
			},

			// column sorting
			sortable: true,

			pagination: true,

			search: {
				input: $('#kt_datatable_search_query'),
				//delay: 400,
				key: 'generalSearch'
			},		
			// columns definition
			columns: [
				{
					field: 'RecordID',
					title: '#',
					sortable: 'asc',
					width: 40,
					type: 'number',
					selector: false,
					textAlign: 'left',
					template: function(data) {
						return '<span class="font-weight-bolder">' + data.RecordID + '</span>';
					}
				},
				{
					field: 'order_id',
					title: 'Order Id',
					width: 80,
					template: function(data) {
						var output = '';
						output += '<div class="font-weight-bolder font-size-lg mb-0">' + data.order_id + '</div>';
						return output;
					}
				}, 				
				{
					field: 'name_en',
					title: 'Branch(EN/AR) Name',
					template: function(data) {
						var output = '';
							output = '<div class="ml-4">\
									<div class="text-dark-75 font-weight-bolder font-size-lg mb-0">' + data.name_en + '</div>\
									<div class="text-muted font-weight-bold text-hover-primary">' + data.name_ar + '</div>\
								</div>\
							</div>';
						return output;
					}
				}, 
				{
					field: 'Order_Details',
					title: 'Order Details',
					width: 120,
					template: function(data) {
						var output = '';

						output += '<button class="btn btn-primary" type="button" id="order_details" data-id="' + data.order_id + '"  type="button" > View Details</button>\
						<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">\
							<div class="modal-dialog modal-dialog-scrollable" role="document" style="max-width: 1000px;">\
								<div class="modal-content">\
									<form method="post">\
										<div id="show_details">\
											<div class="getDetails">\
											</div>\
										</div>\
									</form>\
								</div>\
							</div>\
							</div>\
						';	

						return output;
					}
				}, 					
				{
					field: 'status_order',
					title: 'Status',
					template: function(data) {
						var output = '';
						if (data.status_order == 1 && data.follow_ordrer == 3) {
							output = '<div>Accepted</div>';
						}
						else if (data.status_order == 2 && data.follow_ordrer == 0) {							
							output = '<div>Refused</div>';
						}
						else{
							output = '<div>Pending</div>';							
						}
						return output;
					}
				}, 					
				{
					field: 'date',
					title: 'Date',
					type: 'date',
					format: 'MM/DD/YYYY',
					template: function(data) {
						var output = '';

						output += '<div class="font-weight-bolder text-primary mb-0">' + data.date + '</div>';

						return output;
					},
				}, 
				],
		});
		
		/* $('#kt_datatable_search_query').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'search');
		}) */;

		$('#kt_datatable_search_type').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'Type');
		});



		$('#kt_datatable_search_type').selectpicker();
	};

	return {
		// public functions
		init: function() {
			_demo();
		},
	};
}();

jQuery(document).ready(function() {
	KTAppsUsersListDatatable.init();
});

$('body').on('click', '#order_details', function () {
	var order_id = $(this).attr("data-id");

	$.ajax({
		url: "ajax/view_order_details_modal.php",
		type: "POST",
		data: {view_order_details: order_id},
		success: function (data)
		{

			$("#show_details").empty().append(data);
		}
	});
	$('#exampleModal').modal('show');
});