"use strict";
// Class definition

var KTAppsUsersListDatatable = function() {
	// Private functions
   //var dataJSONArray = JSON.parse();
		//console.log(dataJSONArray);
	// basic demo
	var _demo = function() {
		var datatable = $('#kt_datatable').KTDatatable({
			// datasource definition
			data: {
				type: 'remote',
				//source: dataJSONArray,
				source: {
					read: {
						url: 'ajax/categories_view_ajax.php',
					},
				},
				pageSize: 10, // display 20 records per page
				serverPaging: true,
				//serverFiltering: true,
				//serverSorting: true,
			},
	
			// layout definition
			layout: {
				scroll: false, // enable/disable datatable scroll both horizontal and vertical when needed.
				footer: false, // display/hide footer
			},

			// column sorting
			sortable: true,

			pagination: true,

			search: {
				input: $('#kt_datatable_search_query'),
				//delay: 400,
				key: 'generalSearch'
			},
			
			

			// columns definition
			columns: [
				{
					field: 'RecordID',
					title: '#',
					sortable: 'asc',
					width: 40,
					type: 'number',
					selector: false,
					textAlign: 'left',
					template: function(data) {
						return '<span class="font-weight-bolder">' + data.serial_number + '</span>';
					}
				},  {
					field: 'category_name',
					title: 'Section',
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.category_name + '</div>';
						//output += '<div class="font-weight-bold text-muted">Code: ' + row.ShipCountry + '</div>';

						return output;
					}
				}, 
				{
					field: 'Status',
					title: 'Status',
					template: function(data) {
						var output = '';
						if (data.Status == 1) {
							output = '<div class="form-group row">\
											<div class="col-3">\
												<span class="switch switch-outline switch-icon switch-success">\
													<label>\
														<input type="checkbox" checked="checked" id="show_hide" type_id="0" show_id="'+ data.RecordID +'" name="select" />\
														<span></span>\
													</label>\
												</span>\
											</div>\
										</div>';
						} else {							
							output = '<div class="form-group row">\
											<div class="col-3">\
												<span class="switch switch-outline switch-icon switch-success" data-toggle="modal" data-target="#show_hide">\
													<label>\
														<input type="checkbox" id="show_hide" type_id="1" show_id="'+ data.RecordID +'" name="select" />\
														<span></span>\
													</label>\
												</span>\
											</div>\
										</div>\
										<div id="toggle_on"></div>';
						}
						return output;
					}
				},	
				{
					field: '',
					title: 'Actions',
					sortable: false,
					width: 125,
					overflow: 'visible',
					autoHide: false,
					template: function(data) {
						var id= data.RecordID;
					
						return '\
	                        <a href="?page=categories_edit&id='+ btoa(id) +' " class="btn btn-sm btn-clean btn-icon mr-2" title="Edit details">\
	                            <span class="svg-icon svg-icon-md">\
	                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">\
	                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">\
	                                        <rect x="0" y="0" width="24" height="24"/>\
	                                        <path d="M8,17.9148182 L8,5.96685884 C8,5.56391781 8.16211443,5.17792052 8.44982609,4.89581508 L10.965708,2.42895648 C11.5426798,1.86322723 12.4640974,1.85620921 13.0496196,2.41308426 L15.5337377,4.77566479 C15.8314604,5.0588212 16,5.45170806 16,5.86258077 L16,17.9148182 C16,18.7432453 15.3284271,19.4148182 14.5,19.4148182 L9.5,19.4148182 C8.67157288,19.4148182 8,18.7432453 8,17.9148182 Z" fill="#000000" fill-rule="nonzero"\ transform="translate(12.000000, 10.707409) rotate(-135.000000) translate(-12.000000, -10.707409) "/>\
	                                        <rect fill="#000000" opacity="0.3" x="5" y="20" width="15" height="2" rx="1"/>\
	                                    </g>\
	                                </svg>\
	                            </span>\
	                        </a>\
						';
					},
				}],
		});
		
		/* $('#kt_datatable_search_query').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'search');
		}) */;

		$('#kt_datatable_search_type').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'Type');
		});



		$('#kt_datatable_search_type').selectpicker();
	};

	return {
		// public functions
		init: function() {
			_demo();
		},
	};
}();

jQuery(document).ready(function() {
	KTAppsUsersListDatatable.init();
});

$(document).on('click', '#show_hide', function() {
	var t = $(this);
	Swal.fire({
				text: "Are You Sure Want to Change Status!.",
				icon: "success",
				showCancelButton: true,
				buttonsStyling: false,
				confirmButtonText: "Yes, Change!",
				cancelButtonText: "No, cancel",
				customClass: {
					confirmButton: "btn font-weight-bold btn-primary",
					cancelButton: "btn font-weight-bold btn-default"
				}
			}).then(function (result) {
				if (result.value) {
					var x = t.attr('show_id');
					var y = t.attr('type_id');
					var e = "cat_id=" + x + "&type=" + y + "&action=show_hide_categories";
					$.ajax({
							type: "POST",
							url: "ajax/show_hide_action_ajax.php",
							data: e,
							cache: !1,
							success: function (e){
							  window.location.reload();
							}
						})	
				} else if (result.dismiss === 'cancel') {
					window.location.reload();
				}
			})
		});