"use strict";
// Class definition

var KTAppsUsersListDatatable = function() {
	// Private functions
   //var dataJSONArray = JSON.parse();
		//console.log(dataJSONArray);
	// basic demo
	var _demo = function() {
	    
		var datatable = $('#kt_datatable').KTDatatable({
		   
			// datasource definition
			data: {
				type: 'remote',
				//source: dataJSONArray,
				source: {
					read: {
						url: 'ajax/current_orders_ajax.php',
					},
				},
				pageSize: 10, // display 20 records per page
				serverPaging: true,
				//serverFiltering: true,
				//serverSorting: true,
			},
	
			// layout definition
			layout: {
				scroll: false, // enable/disable datatable scroll both horizontal and vertical when needed.
				footer: false, // display/hide footer
			},

			// column sorting
			sortable: true,

			pagination: true,

			search: {
				input: $('#kt_datatable_search_query'),
				//delay: 400,
				key: 'generalSearch'
			},
			


			// columns definition
			columns: [
				{
					field: 'RecordID',
					title: '#',
					sortable: 'asc',
					width: 40,
					type: 'number',
					selector: false,
					textAlign: 'left',
					template: function(data) {
						return '<span class="font-weight-bolder">' + data.RecordID + '</span>';
					}
				},
				{
					field: 'order_id',
					title: 'Order id',
					sortable: 'asc',
					width: 80,
					type: 'number',
					selector: false,
					textAlign: 'left',
					template: function(data) {
						return '<span class="font-weight-bolder">' + data.order_id + '</span>';
					}
				},	
				{
					field: 'restaurant_name_en',
					title: 'Shop',
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.restaurant_name_en + '</div>';
						
						return output;
					}
				}, 				
				{
					field: 'order_details',
					title: 'Order Details',
					width: 110,
					template: function(data) {
						var output = '';

						//output += '<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#exampleModalScrollable">View Details</button>';
						output += '<button class="btn btn-primary" type="button" id="order_details" data-id="' + data.order_id + '"  type="button" > View Details</button>\
						<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">\
							<div class="modal-dialog modal-dialog-scrollable" role="document" style="max-width: 1000px;">\
								<div class="modal-content">\
									<form method="post">\
										<div id="show_details">\
											<div class="getDetails">\
											</div>\
										</div>\
									</form>\
								</div>\
							</div>\
							</div>\
						';						
						return output; 
					}
				},
				{
					field: 'order_status',
					title: 'Refuse/ Accept',
					width: 150,
					template: function(data) {
						var output = '';
						 if (data.order_status == 0) {			
							if (data.payment == "online") {
								output = '<div class="verifyMeTwo"><a>Not approved</a><br /><br /><a lang="' + data.order_id + '" data-id="' + data.client_id + '" class="btn btn-primary waves-effect waves-light btn-sm verify" id="verify">Approve Order</a><div class="clearfix"><br></div></div>';
							}else {							
								output = '<div class="verifyMeTwo"><a>Not approved</a><br /><br /><a lang="' + data.order_id + '" data-id="' + data.client_id +  '" class="btn btn-primary waves-effect waves-light btn-sm verify" id="verify">Approve Order</a><div class="clearfix"><br></div><a lang="' + data.order_id + '" data-id="' + data.client_id + '" class="btn btn-primary waves-effect waves-light btn-sm cancel_verify" id="cancel_verify"> Refuse</a></div>';
							}
						}
						else if (data.order_status == 1) {
							output ='<div class="cancelVerifyMeTwo"><a>Approved</a><br /><br /><a lang="'  + data.order_id + '" data-id="' + data.client_id + '"  class="btn btn-primary waves-effect waves-light btn-sm cancel_verify" order_status = "1" id="cancel_verify">Cancel Order</a></div>';
						} else if (data.order_status  == 2) {
							output = '<div class="cancelVerifyMeTwo"><a>Refused</a><br /></div>';
						}
						return output;
					}
				},
 				{
					field: 'order_follow',
					title: 'Follow Order',
					autoHide: false,
					template: function(data) {
						var output = '';
							output += ' <select class="form-control" id="edit_process" lang="'  + data.order_id + '" data-id="' + data.client_id + '"  name="edit_process">';
								output += '<option value=" "> Choose</option>';
								if (data.deliver_id != 1) {
									if (data.order_follow == 1) {
										output +=  '<option value="1" selected> Processing</option>';
										output +=  '<option value="3"> Delivered</option>';
									} else if (data.order_follow == 3) {
										output +=  '<option value="1" > Processing</option>';
										output +=  '<option value="3" selected> Delivered</option>';
									} else {
										output +=  '<option value="1" > Processing</option>';
										output +=  '<option value="3" > Delivered</option>';
									}
								} else {
									if (data.order_follow == 1) {
										output +=  '<option value="1" selected> Processing</option>';
										output +=  ' <option value="2"> delivery</option>';
										output +=  '<option value="3"> Delivered</option>';
									} else if (data.order_follow == 2) {
										output +=  '<option value="1" > Processing</option>';
										output +=  ' <option value="2" selected> delivery</option>';
										output +=  '<option value="3"> Delivered</option>';
									} else if (data.order_follow == 3) {
										output +=  '<option value="1" > Processing</option>';
										output +=  ' <option value="2" > delivery</option>';
										output +=  '<option value="3" selected> Delivered</option>';
									} else {
										output +=  '<option value="1" > Processing</option>';
										output +=  ' <option value="2" > delivery</option>';
										output +=  '<option value="3" > Delivered</option>';
									}
								}
							 output += '</select>\
							 ';
						return output;
					},
				},								
				{
					field: 'date',
					title: 'Date Added',
					type: 'date',
					format: 'MM/DD/YYYY',
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder text-primary mb-0">' + row.date + '</div>';
		
						return output;
					},
				}, 

				{
					field: 'Actions',
					title: 'Actions',
					sortable: false,
					width: 125,
					overflow: 'visible',
					autoHide: false,
					template: function(data) {
					var order_id= data.order_id;
						return '\
	                        <a href="?page=print_bill&order_id='+ order_id +'" class="btn btn-sm btn-clean btn-icon mr-2" title="Print" target="_blank">\
	                            <i class="fa fa-print">\
	                            </i>\
	                        </a>\
							  <a data-id="' + order_id + '" class="deletemsg" id="order_delete"><i class="fa fa-trash-o"></i>\
								<span class="svg-icon svg-icon-md">\
	                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">\
	                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">\
	                                        <rect x="0" y="0" width="24" height="24"/>\
	                                        <path d="M6,8 L6,20.5 C6,21.3284271 6.67157288,22 7.5,22 L16.5,22 C17.3284271,22 18,21.3284271 18,20.5 L18,8 L6,8 Z" fill="#000000" fill-rule="nonzero"/>\
	                                        <path d="M14,4.5 L14,4 C14,3.44771525 13.5522847,3 13,3 L11,3 C10.4477153,3 10,3.44771525 10,4 L10,4.5 L5.5,4.5 C5.22385763,4.5 5,4.72385763 5,5 L5,5.5 C5,5.77614237 5.22385763,6 5.5,6 L18.5,6 C18.7761424,6 19,5.77614237 19,5.5 L19,5 C19,4.72385763 18.7761424,4.5 18.5,4.5 L14,4.5 Z" fill="#000000" opacity="0.3"/>\
	                                    </g>\
	                                </svg>\
	                            </span>\
	                        </a>\
						';
					},
				}],
		});
		
		$('#kt_datatable_search_type').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'section_id');
		});

	};

	return {
		// public functions
		init: function() {
			_demo();
		},
	};
}();

jQuery(document).ready(function() {
	KTAppsUsersListDatatable.init();
});


jQuery(window).ready(function () {

	var time = 60

	setInterval(function () {

		time--;
		$('#time').html(time);
		if (time === 0) {

			location.reload()
		}


	}, 1000);
});

function refreshPage(){
    window.location.reload();
} 

$(document).on('click', '#verify', function() {

	var order_id = $(this).attr('lang');
	var client_id = $(this).attr('data-id');
	
	swal.fire({
		text: "Confirmation of approve?",
		icon: "success",
		showCancelButton: true,
		buttonsStyling: false,
		confirmButtonText: "Yes, Change!",
		cancelButtonText: "No, cancel",
		customClass: {
			confirmButton: "btn font-weight-bold btn-primary",
			cancelButton: "btn font-weight-bold btn-default"
		}
	}).then(function (result) {
		if (result.value) {
			/* var x = t.attr('show_id');
			var y = t.attr('type_id'); */
			 Swal.fire('Approved!', '', 'success')
			var e = "order_id=" + order_id + "&client_id=" + client_id + "&action=verify";
			$.ajax({
					type: "POST",
					url: "ajax/refuse_accept_orders_ajax.php",
					data: e,
					cache: !1,
					success: function (e){
					  window.location.reload();
					}
				})	
		} else if (result.dismiss === 'cancel') {

			window.location.reload();
		}
	});				
});
 $(document).on('click', '#cancel_verify', function() {
	var order_id = $(this).attr('lang');
	var client_id = $(this).attr('data-id');
	swal.fire({
			text: "Cancel / Refuse Order?",
			icon: "success",
			showCancelButton: true,
			buttonsStyling: false,
			confirmButtonText: "Yes, Change!",
			cancelButtonText: "No, cancel",
			customClass: {
				confirmButton: "btn font-weight-bold btn-primary",
				cancelButton: "btn font-weight-bold btn-default"
			}
	}). then(function (result) {
		if (result.value) {
		Swal.fire("Order Canceled / Refused", "", "success")
		var e = "order_id=" + order_id + "&client_id=" + client_id + "&action=cancel_verify";
		
		$.ajax({
				type: "POST",
				url: "ajax/refuse_accept_orders_ajax.php",
				data: e,
				cache: !1,
				success: function (e){
				  window.location.reload();
				}
			})	
		}  else if (result.dismiss === 'cancel') {

			window.location.reload();
		}
	})
});
$(document).on('change', '#edit_process', function() { 
	event.preventDefault();
	var order_id = $(this).attr('lang');
	var client_id = $(this).attr('data-id');
	var edit_follow_order = $(this).val();
	var e = 'check_order_id=' + order_id + "&action=check_order_id";

	$.ajax({
		type: "POST",
		url: "ajax/refuse_accept_orders_ajax.php",
		data: e,
        dataType: 'text',
		cache: !1,
		success: function (data) {

			if (data == 1) {

				swal.fire({
						text: "Change status",
						icon: "success",
						showCancelButton: true,
						buttonsStyling: false,
						confirmButtonText: "Yes, Change!",
						cancelButtonText: "No, cancel",
						customClass: {
							confirmButton: "btn font-weight-bold btn-primary",
							cancelButton: "btn font-weight-bold btn-default"
						}
				}).  then(function (result) {
						if (result.value) {
							Swal.fire("Status changed", "", "success")
							var dataString = 'edit_follow_order=' + edit_follow_order + '&order_id=' + order_id + '&client_id=' + client_id;
							$.ajax({
								type: "POST",
								url: "ajax/refuse_accept_orders_ajax.php",
								data: dataString,
								cache: !1,
								success: function (data) {
									 window.location.reload();
								}
							});
						} else {
							Swal.fire("Changed ", "changed", "error")
						}
					});
			} else {
				swal.fire("Sorry,  order must be approved first", "Order must be approved first", "error");
			}
		}
	});
});

$('body').on('click', '#order_details', function () {
	var order_id = $(this).attr("data-id");

	$.ajax({
		url: "ajax/view_order_details_modal.php",
		type: "POST",
		data: {view_order_details: order_id},
		success: function (data)
		{

			$("#show_details").empty().append(data);
		}
	});
	$('#exampleModal').modal('show');
});


$(document).on('click', '#order_delete', function() {

	var order_id = $(this).attr('data-id');
	var urlgo = $(this).attr('data-link');
	$('#delete_order').modal('show');
	$('body').on('click', '#submit_delete_reason', function () {
		var delete_reason = $(".delete_reason").val();	
		var e = "remove_order_id=" + order_id + "&delete_reason= " + delete_reason + "&action=remove_order_id";
		if (delete_reason != '') {
			$.ajax({
				type: "POST",
				url: "ajax/view_current_orders_delete.php",
				data: e,
				cache: false,
				success: function (data) {
					$(".deleteData").html(e);
					$("." + order_id).remove();
					window.location.reload();
				}
			});
			$('#delete_order').modal('hide');

		} else {
			alert("Please enter the reason for the deletion")
		}
	});
});
