/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
var __webpack_exports__ = {};
/*!*****************************************************!*\
  !*** ../demo8/src/js/pages/custom/user/add-user.js ***!
  \*****************************************************/


// Class Definition
var KTAddUser = function () {
	$("#kt_inputmask_4").inputmask({
		"mask": "99-9999999",
		placeholder: "" // remove underscores from the input mask
	});		
	// Private Variables
	var _wizardEl;
	var _formEl;
	var _wizardObj;
	var _avatar;
	var _validations = [];

	// Private Functions
	var _initWizard = function () {
		// Initialize form wizard
		_wizardObj = new KTWizard(_wizardEl, {
			startStep: 1, // initial active step number
			clickableSteps: false  // allow step clicking
		});

		// Validation before going to next page
		_wizardObj.on('change', function (wizard) {
			if (wizard.getStep() > wizard.getNewStep()) {
				return; // Skip if stepped back
			}

			// Validate form before change wizard step
			var validator = _validations[wizard.getStep() - 1]; // get validator for currnt step

			if (validator) {
				validator.validate().then(function (status) {
					if (status == 'Valid') {
						//wizard.goTo(wizard.getNewStep());
						//KTUtil.scrollTop();
							$(document).on('click', '.addpage', function() {
								// Submit event
								
									Swal.fire({
										text: "All is good! Please confirm the form submission.",
										icon: "success",
										showCancelButton: true,
										buttonsStyling: false,
										confirmButtonText: "Yes, submit!",
										cancelButtonText: "No, cancel",
										customClass: {
											confirmButton: "btn font-weight-bold btn-primary",
											cancelButton: "btn font-weight-bold btn-default"
										}
									}).then(function (result) {
										if (result.value) {
											//var form = $(this);
											//_formEl.submit(); // Submit form
										  /* $.ajax({
													 url: "ajax/client_edit_ajax.php",
													 type: 'POST',
													 data: $("#kt_form").serialize(), 
													 success: function(data){
														window.location = "?page=client_view";	
													 }
											});  */
											ajaxfunction();
											
										} else if (result.dismiss === 'cancel') {
											Swal.fire({
												text: "Your form has not been submitted!.",
												icon: "error",
												buttonsStyling: false,
												confirmButtonText: "Ok, got it!",
												customClass: {
													confirmButton: "btn font-weight-bold btn-primary",
												}
											});
										}
									});
								
							});						
					} else {
						Swal.fire({
							text: "Sorry, please enter all fields.",
							icon: "error",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn font-weight-bold btn-light"
							}
						}).then(function () {
							KTUtil.scrollTop();
						});
					}
				});
			}

			return false;  // Do not change wizard step, further action will be handled by he validator
		});

		// Change event
		_wizardObj.on('changed', function (wizard) {
			KTUtil.scrollTop();
		});

	}

	var _initValidations = function () {
		// Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/

		// Validation Rules For Step 1
		_validations.push(FormValidation.formValidation(
			_formEl,
			{
				fields: {
					client_name: {
						validators: {
							notEmpty: {
								message: 'This value is required'
							}
						}
					},
			
					wallet: {
						validators: {
							notEmpty: {
								message: 'This value is required'
							}
						}
					},
					points: {
						validators: {
							notEmpty: {
								message: 'This value is required'
							}
						}
					},
					client_email: {
						validators: {
							notEmpty: {
								message: 'Email is required'
							},
							emailAddress: {
								message: 'The value is not a valid email address'
							}
						}
					},
					/* client_phone: {
						validators: {
							notEmpty: {
								message: 'Phone is required'
							},
							phone: {
								country: 'US',
								message: 'The value is not a valid US phone number. (e.g 5554443333)'
							}
						}
					}, */

				},
				plugins: {
					trigger: new FormValidation.plugins.Trigger(),
					// Bootstrap Framework Integration
					bootstrap: new FormValidation.plugins.Bootstrap({
						//eleInvalidClass: '',
						eleValidClass: '',
					})
				}
			}
		));




	}

	var _initAvatar = function () {
		_avatar = new KTImageInput('kt_user_add_avatar');
	}

	return {
		// public functions
		init: function () {
			_wizardEl = KTUtil.getById('kt_wizard');
			_formEl = KTUtil.getById('kt_form');

			_initWizard();
			_initValidations();
			_initAvatar();
		}
	};
}();




function ajaxfunction(){
	var myFormData = document.getElementById("kt_form");
	var ajax = new XMLHttpRequest();
	ajax.onreadystatechange = function(e){
		if(this.readyState == 4 && this.status == 200){
			var data = this.responseText;
			//alert(data);
			var response = JSON.parse(data);
			//alert(response);
			if(response['status'] == '1'){
			window.location.href = "?page=client_view";
			
			} else {
				swal.fire({
					text: response['message'],
					icon: "error",
					buttonsStyling: false,
					confirmButtonText: "Ok, got it!",
					customClass: {
						confirmButton: "btn font-weight-bold btn-light-primary"
					}
				}).then(function() {
					KTUtil.scrollTop();
				});
			}		
		} 
	}
	ajax.open("POST","ajax/client_edit_ajax.php");
	ajax.send(new FormData(myFormData));
	e.preventDefault();
}

jQuery(document).ready(function () {
	KTAddUser.init();
});


/******/ })()
;
//# sourceMappingURL=add-user.js.map