
"use strict";
// Class definition

var KTAppsUsersListDatatable = function() {
	// Private functions
   //var dataJSONArray = JSON.parse();
		//console.log(dataJSONArray);
	// basic demo
	var _demo = function() {
		//console.log($('#client_id').val());
		var datatable = $('#kt_datatable').KTDatatable({
			
			// datasource definition
			data: {
				type: 'remote',
				//source: dataJSONArray,
				source: {
					read: {
						
						url: "ajax/client_fav_sub_view_ajax.php",
						method: 'POST',
						params: {						
							client_id: $('#client_id').val(),							
						}

					},
				},

				pageSize: 10, // display 20 records per page
				serverPaging: true,
				//serverFiltering: true,
				//serverSorting: true,
			},
	
			// layout definition
			layout: {
				scroll: false, // enable/disable datatable scroll both horizontal and vertical when needed.
				footer: false, // display/hide footer
			},

			// column sorting
			sortable: true,

			pagination: true,

			search: {
				input: $('#kt_datatable_search_query'),
				//delay: 400,
				key: 'generalSearch'
			},		
			// columns definition
			columns: [
				{
					field: 'RecordID',
					title: '#',
					sortable: 'asc',
					width: 40,
					type: 'number',
					selector: false,
					textAlign: 'left',
					template: function(data) {
						return '<span class="font-weight-bolder">' + data.RecordID + '</span>';
					}
				}, 
				{
					field: 'sub_category_name',
					title: 'Name',
					template: function(row) {
						var output = '';
						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.sub_category_name + '</div>';
						return output;
					}
				}, 
				{
					field: 'parent_catag',
					title: 'Category',
					template: function(row) {
						var output = '';
						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.parent_catag + '</div>';
						return output;
					}
				}, 					
				{
					field: 'image',
					title: 'Image',
					width: 250,
					template: function(data) {
					
						var output = '';
						output = '<div class="d-flex align-items-center">\
								<div class="symbol symbol-40 symbol-sm flex-shrink-0">\
									<img class="image-input-wrapper" src="' + data.image + '" alt="Image">\
								</div>\
							</div>';
						return output;
					}
				}, 
	
				{
					field: 'date',
					title: 'Date Added',
					type: 'date',
					format: 'MM/DD/YYYY',
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder text-primary mb-0">' + row.date + '</div>';

						return output;
					},
				}, 
				],
		});
		
		/* $('#kt_datatable_search_query').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'search');
		}) */;

		$('#kt_datatable_search_type').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'Type');
		});



		$('#kt_datatable_search_type').selectpicker();
	};

	return {
		// public functions
		init: function() {
			_demo();
		},
	};
}();

jQuery(document).ready(function() {
	KTAppsUsersListDatatable.init();
});

