"use strict";
// Class definition

var KTAppsUsersListDatatable = function() {
	// Private functions
   //var dataJSONArray = JSON.parse();
		//console.log(dataJSONArray);
	// basic demo
	var _demo = function() {
		var datatable = $('#kt_datatable').KTDatatable({
			// datasource definition
			data: {
				type: 'remote',
				//source: dataJSONArray,
				source: {
					read: {
						url: 'ajax/client_view_ajax.php',
					},
				},
				pageSize: 10, // display 20 records per page
				serverPaging: true,
				//serverFiltering: true,
				//serverSorting: true,
			},
	
			// layout definition
			layout: {
				scroll: false, // enable/disable datatable scroll both horizontal and vertical when needed.
				footer: false, // display/hide footer
			},

			// column sorting
			sortable: true,

			pagination: true,

			search: {
				input: $('#kt_datatable_search_query'),
				//delay: 400,
				key: 'generalSearch'
			},
			
			

			// columns definition
			columns: [
				{
					field: 'RecordID',
					title: '#',
					sortable: 'asc',
					width: 40,
					type: 'number',
					selector: false,
					textAlign: 'left',
					template: function(data) {
						return '<span class="font-weight-bolder">' + data.RecordID + '</span>';
					}
				}, {
					field: '',
					title: 'Name',
					width: 100,
					template: function(data) {
						var output = '';
							output = '<div class="d-flex align-items-center">\
								<div class="ml-4">\
									<div class="text-dark-75 font-weight-bolder font-size-lg mb-0">' + data.client_name + '</div>\
									<a href="#" class="text-muted font-weight-bold text-hover-primary">' + data.client_phone + '</a>\
								</div>\
							</div>';
						return output;
					}
				}, {
					field: 'points',
					title: 'Points',
					width: 70,
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.points + '</div>';
						return output;
					}
				}, 
				{	
					field: 'wallet',
					title: 'Wallet',
					width: 80,
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.wallet + '</div>';
						return output;
					}
				}, 
				{
					field: 'orders',
					title: 'Orders',
					width: 80,
					template: function(data) {
						var output = '';
						var id= data.client_id;
						//output += '<div class="font-weight-bolder text-primary mb-0">' + data.orders + '</div>';
						output = '<a href="?page=client_orders&client_id='+ id +'" class="btn btn-sm btn-clean btn-icon" title="Client Ordres">' + data.orders + '</a>';
						return output;
					},
				}, 
				{
					field: 'Favourite',
					title: 'Fav',
					width: 60,
					template: function(data) {
						var output = '';
						var id= data.client_id;
							if (data.fav > 0) {
							//output = '<a id="fav_sub" view_id="' + id + '" class="btn btn-sm btn-clean btn-icon" title="Fav"><i class="fa fa-eye"></i></a>';
								
							output = '<a href="?page=client_fav_sub_view&client_id='+ id +'" class="btn btn-sm btn-clean btn-icon" title="Fav"><i class="fa fa-eye"></i></a>';
							}else {
                                  output = '<div>There are no favorite items</div>';
							}
						return output;
					}
				},
				
				{
					field: 'Comments',
					title: 'Comments',
					width: 80,
					template: function(data) {
						var output = '';
						var id= data.client_id;
						if (data.comment > 0) {
							output = '<a href="?page=comments_view&client_id='+ id +'" id="comments_view_list" class="btn btn-sm btn-clean btn-icon" title="Comments"><i class="fa fa-eye"></i></a>';
						}else{
							output = '<div>No comments</div>';
						}

						return output;
					}
				},				
				{
					field: 'Date',
					title: 'Date Added',
					type: 'date',
					format: 'MM/DD/YYYY',
					template: function(row) {
						var output = '';
						output += '<div class="font-weight-bolder text-primary mb-0">' + row.Date + '</div>';
						return output;
					},
				}, 
				{
					field: 'Actions',
					title: 'Actions',
					sortable: false,
					width: 125,
					overflow: 'visible',
					autoHide: false,
					template: function(data) {
						var client_id= data.client_id;
						return '\
							<a href="?page=chat&client_id='+ client_id +'" class="btn btn-sm btn-clean btn-icon mr-2" title="Chat">\
								<i class="fa fa-comment"></i>\
	                        </a>\
	                        <a href="?page=client_edit&client_id='+ client_id +'" class="btn btn-sm btn-clean btn-icon mr-2" title="Edit details">\
	                            <span class="svg-icon svg-icon-md">\
	                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">\
	                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">\
	                                        <rect x="0" y="0" width="24" height="24"/>\
	                                        <path d="M8,17.9148182 L8,5.96685884 C8,5.56391781 8.16211443,5.17792052 8.44982609,4.89581508 L10.965708,2.42895648 C11.5426798,1.86322723 12.4640974,1.85620921 13.0496196,2.41308426 L15.5337377,4.77566479 C15.8314604,5.0588212 16,5.45170806 16,5.86258077 L16,17.9148182 C16,18.7432453 15.3284271,19.4148182 14.5,19.4148182 L9.5,19.4148182 C8.67157288,19.4148182 8,18.7432453 8,17.9148182 Z" fill="#000000" fill-rule="nonzero"\ transform="translate(12.000000, 10.707409) rotate(-135.000000) translate(-12.000000, -10.707409) "/>\
	                                        <rect fill="#000000" opacity="0.3" x="5" y="20" width="15" height="2" rx="1"/>\
	                                    </g>\
	                                </svg>\
	                            </span>\
	                        </a>\
						';
					},
				}],
		});
		
		/* $('#kt_datatable_search_query').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'search');
		}) */;

		$('#kt_datatable_search_name').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'client_name');
		});

		$('#kt_datatable_search_phone').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'client_phone');
		});		
		$('#kt_datatable_search_email').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'client_email');
		});

		$('#kt_datatable_search_name, #kt_datatable_search_phone, #kt_datatable_search_email').selectpicker();
	};

	return {
		// public functions
		init: function() {
			_demo();
		},
	};
}();

jQuery(document).ready(function() {
	KTAppsUsersListDatatable.init();
});



	$(document).on('click', '#fav_sub', function() {
			
		
		var t = $(this);
		var e = t.attr('view_id');		
		var x = 'client_id=' + e; 
		
		alert(x);

		$.ajax({
			 url: "ajax/client_fav_sub_view.php",			 
			 type: 'POST',
			 data: x, 
			 success: function(data){
				 alert(data);
				window.location = "?page=client_fav_sub_view&client_id="+e;	
			 }

		}); 
	});
	
	$('#comments_view_list').click(function() {
		location.reload();
	});