"use strict";
// Class definition

var KTAppsUsersListDatatable = function() {
	// Private functions
   //var dataJSONArray = JSON.parse();
		//console.log(dataJSONArray);
	// basic demo
	var _demo = function() {
		var datatable = $('#kt_datatable').KTDatatable({
			// datasource definition
			data: {
				type: 'remote',
				//source: dataJSONArray,
				source: {
					read: {
						url: 'ajax/parentCatAjax.php',
					},
				},
				pageSize: 10, // display 20 records per page
				serverPaging: true,
				//serverFiltering: true,
				//serverSorting: true,
			},
	
			// layout definition
			layout: {
				scroll: false, // enable/disable datatable scroll both horizontal and vertical when needed.
				footer: false, // display/hide footer
			},

			// column sorting
			sortable: true,

			pagination: true,

			search: {
				input: $('#kt_datatable_search_query'),
				//delay: 400,
				key: 'generalSearch'
			},
			
			

			// columns definition
			columns: [
				{
					field: 'RecordID',
					title: '#',
					sortable: 'asc',
					width: 40,
					type: 'number',
					selector: false,
					textAlign: 'left',
					template: function(data) {
						return '<span class="font-weight-bolder">' + data.RecordID + '</span>';
					}
				}, {
					field: 'OrderID',
					title: 'Parent Category(En/Ar)',
					width: 200,
					template: function(data) {
						var number = KTUtil.getRandomInt(1, 14);
						var user_img = '100_' + number + '.jpg';

						var output = '';
						if (data.image) {
							output = '<div class="d-flex align-items-center">\
								<div class="symbol symbol-40 symbol-sm flex-shrink-0">\
									<img class="" src="' + data.image + '" alt="photo">\
								</div>\
								<div class="ml-4">\
									<div class="text-dark-75 font-weight-bolder font-size-lg mb-0">' + data.parent_category_name + '</div>\
									<a href="#" class="text-muted font-weight-bold text-hover-primary">' + data.parent_category_name_en + '</a>\
								</div>\
							</div>';
						}
						else {
							var stateNo = KTUtil.getRandomInt(0, 7);
							var states = [
								'success',
								'primary',
								'danger',
								'success',
								'warning',
								'dark',
								'primary',
								'info'];
							var state = states[stateNo];

							output = '<div class="d-flex align-items-center">\
								<div class="symbol symbol-40 symbol-light-'+state+' flex-shrink-0">\
									<span class="symbol-label font-size-h4 font-weight-bold">' + data.parent_category_name.substring(0, 1) + '</span>\
								</div>\
								<div class="ml-4">\
									<div class="text-dark-75 font-weight-bolder font-size-lg mb-0">' + data.parent_category_name + '</div>\
									<a href="#" class="text-muted font-weight-bold text-hover-primary">' + data.parent_category_name_en + '</a>\
								</div>\
							</div>';
						}

						return output;
					}
				}, 
				{
					field: 'shop_name',
					title: 'Shop Name',
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.shop_name + '</div>';
						//output += '<div class="font-weight-bold text-muted">Code: ' + row.ShipCountry + '</div>';

						return output;
					}
				},
				{
					field: 'arrange',
					title: 'Arrange',
					width: 70,
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.arrange + '</div>';
						//output += '<div class="font-weight-bold text-muted">Code: ' + row.ShipCountry + '</div>';

						return output;
					}
				},

				{
					field: 'display',
					title: 'Show?',
					width: 80,
					template: function(data) {
						var output = '';
						if (data.display == 1) {
							output = '<div class="form-group row">\
											<div class="col-3">\
												<span class="switch switch-outline switch-icon switch-success" data-toggle="modal" data-target="#show_hide">\
													<label>\
														<input type="checkbox" id="show_hide" type_id="0" show_id="'+ data.parent_category_id +'" checked="checked" name="select" />\
														<span></span>\
													</label>\
												</span>\
											</div>\
										</div>';
						}
						else {							
							output = '<div class="form-group row">\
											<div class="col-3">\
												<span class="switch switch-outline switch-icon switch-success" data-toggle="modal" data-target="#show_hide">\
													<label>\
														<input type="checkbox" id="show_hide" type_id="1" show_id="'+ data.parent_category_id +'" name="select" />\
														<span></span>\
													</label>\
												</span>\
											</div>\
										</div>';
						}

						return output;
					}
				},	
				{
					field: 'ShipDate',
					title: 'Date Added',
					type: 'date',
					format: 'MM/DD/YYYY',
					template: function(row) {
						var output = '';

						var status = {
							1: {'title': 'Paid', 'class': ' label-light-primary'},
							2: {'title': 'Approved', 'class': ' label-light-danger'},
							3: {'title': 'Pending', 'class': ' label-light-primary'},
							4: {'title': 'Rejected', 'class': ' label-light-success'},
						};
						var index = KTUtil.getRandomInt(1, 4);

						output += '<div class="font-weight-bolder text-primary mb-0">' + row.ShipDate + '</div>';
						//output += '<div class="text-muted">' + status[index].title + '</div>';

						return output;
					},
				}, 

				{
					field: 'Actions',
					title: 'Actions',
					sortable: false,
					width: 125,
					overflow: 'visible',
					autoHide: false,
					template: function(data) {
						if(data.sub_cat_count > 0){
							var href = '?page=sub_cat_by_filter&parent_category_id='+ btoa(data.parent_category_id);
							var eye = '<i class="fa fa-eye"></i>'
							var title= 'View'
						} else {
							var href = "#";
							var eye = '<i class="fa fa-eye-slash"></i>'
							var title= 'No sub category for this parent menu category'
						}
						return '\
							<a href="'+href+'" class="btn btn-sm btn-clean btn-icon" title="'+title+'">\
	                        '+eye+'\
	                        </a>\
	                        <a href="?page=parent_category_edit&id='+ btoa(data.parent_category_id) +'" class="btn btn-sm btn-clean btn-icon mr-2" title="Edit details">\
	                            <span class="svg-icon svg-icon-md">\
	                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">\
	                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">\
	                                        <rect x="0" y="0" width="24" height="24"/>\
	                                        <path d="M8,17.9148182 L8,5.96685884 C8,5.56391781 8.16211443,5.17792052 8.44982609,4.89581508 L10.965708,2.42895648 C11.5426798,1.86322723 12.4640974,1.85620921 13.0496196,2.41308426 L15.5337377,4.77566479 C15.8314604,5.0588212 16,5.45170806 16,5.86258077 L16,17.9148182 C16,18.7432453 15.3284271,19.4148182 14.5,19.4148182 L9.5,19.4148182 C8.67157288,19.4148182 8,18.7432453 8,17.9148182 Z" fill="#000000" fill-rule="nonzero"\ transform="translate(12.000000, 10.707409) rotate(-135.000000) translate(-12.000000, -10.707409) "/>\
	                                        <rect fill="#000000" opacity="0.3" x="5" y="20" width="15" height="2" rx="1"/>\
	                                    </g>\
	                                </svg>\
	                            </span>\
	                        </a>\
	                        <a id="delete" del_id="'+ data.parent_category_id +'" class="btn btn-sm btn-clean btn-icon" title="Delete">\
	                            <span class="svg-icon svg-icon-md">\
	                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">\
	                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">\
	                                        <rect x="0" y="0" width="24" height="24"/>\
	                                        <path d="M6,8 L6,20.5 C6,21.3284271 6.67157288,22 7.5,22 L16.5,22 C17.3284271,22 18,21.3284271 18,20.5 L18,8 L6,8 Z" fill="#000000" fill-rule="nonzero"/>\
	                                        <path d="M14,4.5 L14,4 C14,3.44771525 13.5522847,3 13,3 L11,3 C10.4477153,3 10,3.44771525 10,4 L10,4.5 L5.5,4.5 C5.22385763,4.5 5,4.72385763 5,5 L5,5.5 C5,5.77614237 5.22385763,6 5.5,6 L18.5,6 C18.7761424,6 19,5.77614237 19,5.5 L19,5 C19,4.72385763 18.7761424,4.5 18.5,4.5 L14,4.5 Z" fill="#000000" opacity="0.3"/>\
	                                    </g>\
	                                </svg>\
	                            </span>\
	                        </a>\
						';
					},
				}],
		});
		
		/* $('#kt_datatable_search_query').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'search');
		}) */;

		$('#kt_datatable_search_type').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'Type');
		});



		$('#kt_datatable_search_type').selectpicker();
	};

	return {
		// public functions
		init: function() {
			_demo();
		},
	};
}();

jQuery(document).ready(function() {
	KTAppsUsersListDatatable.init();
});


$(document).on('click', '#delete', function() {
	var t = $(this);
	Swal.fire({
				text: "Are You Sure Want to Delete!.",
				icon: "success",
				showCancelButton: true,
				buttonsStyling: false,
				confirmButtonText: "Yes, delete!",
				cancelButtonText: "No, cancel",
				customClass: {
					confirmButton: "btn font-weight-bold btn-primary",
					cancelButton: "btn font-weight-bold btn-default"
				}
			}).then(function (result) {
				if (result.value) {
					var x = t.attr('del_id');
					var e = "category=" + x +"&action=delete";
					$.ajax({
							type: "POST",
							url: "ajax/delete_parent_cat_ajax.php",
							data: e,
							cache: !1,
							success: function (e){
								window.location.reload();
							}
						})	
				} else if (result.dismiss === 'cancel') {
					return false;
				}
			}); 
	});

	$(document).on('click', '#show_hide', function() {
	var t = $(this);
	Swal.fire({
				text: "Are You Sure Want to Change Status!.",
				icon: "success",
				showCancelButton: true,
				buttonsStyling: false,
				confirmButtonText: "Yes, Change!",
				cancelButtonText: "No, cancel",
				customClass: {
					confirmButton: "btn font-weight-bold btn-primary",
					cancelButton: "btn font-weight-bold btn-default"
				}
			}).then(function (result) {
				if (result.value) {
					var x = t.attr('show_id');
					var y = t.attr('type_id');
					var e = "change_cat_status_on=" + x + "&type=" + y + "&action=show_hide_parent_cat";
					$.ajax({
							type: "POST",
							url: "ajax/show_hide_action_ajax.php",
							data: e,
							cache: !1,
							success: function (e){
							  window.location.reload();
							}
						})	
				} else if (result.dismiss === 'cancel') {
					window.location.reload();
				}
			});
	});
