"use strict";
// Class definition

var KTAppsUsersListDatatable = function() {
	// Private functions
   //var dataJSONArray = JSON.parse();
		//console.log(dataJSONArray);
	// basic demo
	var _demo = function() {
		var datatable = $('#kt_datatable').KTDatatable({
			// datasource definition
			data: {
				type: 'remote',
				//source: dataJSONArray,
				source: {
					read: {
						url: 'ajax/last_orders_ajax.php',
					},
				},
				pageSize: 10, // display 20 records per page
				serverPaging: true,
				//serverFiltering: true,
				//serverSorting: true,
			},
	
			// layout definition
			layout: {
				scroll: false, // enable/disable datatable scroll both horizontal and vertical when needed.
				footer: false, // display/hide footer
			},

			// column sorting
			sortable: true,

			pagination: true,

			search: {
				input: $('#kt_datatable_search_query'),
				//delay: 400,
				key: 'generalSearch'
			},
			
			

			// columns definition
			columns: [
				{
					field: 'RecordID',
					title: '#',
					sortable: 'asc',
					width: 40,
					type: 'number',
					selector: false,
					textAlign: 'left',
					template: function(row) {
						return '<span class="font-weight-bolder">' + row.RecordID + '</span>';
					}
				},
				{
					field: 'order_id',
					title: 'Order id',
					sortable: 'asc',
					width: 80,
					type: 'number',
					selector: false,
					textAlign: 'left',
					template: function(row) {
						return '<span class="font-weight-bolder">' + row.order_id + '</span>';
					}
				},				
				{
					field: 'restaurant_name_en',
					title: 'Shop Name',
					width: 120,
					template: function(row) {
					
						var output = '';
							output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.restaurant_name_en + '</div>';

						return output;
					}
				}, 
				{
					field: 'Order_Details',
					title: 'Order Details',
					width: 120,
					template: function(row) {
						var output = '';

						output += '<button class="btn btn-primary" type="button" id="order_details" data-id="' + row.order_id + '"  type="button" > View Details</button>\
						<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">\
							<div class="modal-dialog modal-dialog-scrollable" role="document" style="max-width: 1000px;">\
								<div class="modal-content">\
									<form method="post">\
										<div id="show_details">\
											<div class="getDetails">\
											</div>\
										</div>\
									</form>\
								</div>\
							</div>\
							</div>\
						';	

						return output;
					}
				},			
				{
					field: 'order_status',
					title: 'Status',
					width: 90,
					template: function(row) {
						var output = '';

						//output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.Status + '</div>';
						if (row.order_status == 1 && row.order_follow == 3) {
							output += 'Accepted';
						} else if (row.order_status == 2 && row.order_follow == 0) {
							output += 'Refused';
						}
						return output;
					}
				},
				
				{
					field: 'date',
					title: 'Date Added',
					type: 'date',
					format: 'MM/DD/YYYY',
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder text-primary mb-0">' + row.date + '</div>';
		
						return output;
					},
				}, 

				{
					field: 'Actions',
					title: 'Actions',
					sortable: false,
					width: 125,
					overflow: 'visible',
					autoHide: false,
					template: function(row) {
						var order_id= row.order_id;
						return '\
	                        <a href="?page=print_bill&order_id='+ order_id +'" class="btn btn-sm btn-clean btn-icon mr-2" title="Print" target="_blank">\
	                            <i class="fa fa-print">\
	                            </i>\
	                        </a>\
						';
					},
				}
				],
		});
		
		$('#kt_datatable_search_type').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'section_id');
		});
		

	};

	return {
		// public functions
		init: function() {
			_demo();
		},
	};
}();


jQuery(document).ready(function() {
	KTAppsUsersListDatatable.init();
});

$('body').on('click', '#order_details', function () {
	var order_id = $(this).attr("data-id");

	$.ajax({
		url: "ajax/view_order_details_modal.php",
		type: "POST",
		data: {view_order_details: order_id},
		success: function (data)
		{

			$("#show_details").empty().append(data);
		}
	});
	$('#exampleModal').modal('show');
});

$(document).on('click', '#last_order_delete', function() {


	var order_id = $(this).attr('data-id');
	var urlgo = $(this).attr('data-link');
	$('#delete_order').modal('show');
	$('body').on('click', '#submit_delete_reason', function () {
		var delete_reason = $(".delete_reason").val();	
		var e = "remove_order_id=" + order_id + "&delete_reason= " + delete_reason + "&action=remove_order_id";
		if (delete_reason != '') {
			$.ajax({
				type: "POST",
				url: "ajax/view_current_orders_delete.php",
				data: e,
				cache: false,
				success: function (data) {
					$(".deleteData").html(e);
					$("." + order_id).remove();
					window.location.reload();
				}
			});
			$('#delete_order').modal('hide');

		} else {
			alert("Please enter the reason for the deletion")
		}
	});
});