"use strict";
// Class definition

var KTAppsUsersListDatatable = function() {
	// Private functions
   //var dataJSONArray = JSON.parse();
		//console.log(dataJSONArray);
	// basic demo
	var _demo = function() {
		var datatable = $('#kt_datatable').KTDatatable({
			// datasource definition
			data: {
				type: 'remote',
				//source: dataJSONArray,
				source: {
					read: {
						url: 'ajax/client_report_ajax.php',
					},
				},
				pageSize: 10, // display 20 records per page
				serverPaging: true,
				//serverFiltering: true,
				//serverSorting: true,
			},
	
			// layout definition
			layout: {
				scroll: false, // enable/disable datatable scroll both horizontal and vertical when needed.
				footer: false, // display/hide footer
			},

			// column sorting
			sortable: true,

			pagination: true,

			search: {
				input: $('#kt_datatable_search_query'),
				//delay: 400,
				key: 'generalSearch'
			},
			
			

			// columns definition
			columns: [
				{
					field: 'SNo',
					title: '#',
					sortable: 'asc',
					width: 20,
					type: 'number',
					selector: false,
					textAlign: 'left',
					template: function(data) {
						return '<span class="font-weight-bolder">' + data.SNo + '</span>';
					}
				},
				{
					field: 'order_id',
					title: 'Order id',
					sortable: 'asc',
					width: 50,
					type: 'number',
					selector: false,
					textAlign: 'left',
					template: function(data) {
						return '<span class="font-weight-bolder">' + data.order_id + '</span>';
					}
				},	
				{
					field: 'restaurant_name',
					title: 'Restaurant',
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.restaurant_name + '</div>';
						
						return output;
					}
				}, 
				{
					field: 'branch',
					title: 'Branch',
					width: 90,
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.branch + '</div>';
						
						return output;
					}
				},				
				{
					field: 'client_name',
					title: 'Client Name',
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.client_name + '</div>';
						
						return output;
					}
				},	
				{
					field: 'order_price',
					title: 'Order Price',
					width: 60,
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.order_price + '</div>';
						
						return output;
					}
				},	
				{
					field: 'discount',
					title: 'Discount Percentage',
					width: 100,
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.discount + '</div>';
						
						return output;
					}
				},	
				{
					field: 'total',
					title: 'Total',
					width: 50,
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.total + '</div>';
						
						return output;
					}
				},
				{
					field: 'payment',
					title: 'Payment Method',
					width: 70,
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.payment + '</div>';
						
						return output;
					}
				}, 
				{
					field: 'status',
					title: 'Status',
					width: 80,
					template: function(row) {

						var status = {
							0: {
							  'title': 'Pending',
							  'class': ' label-light-warning',
							},
							1: {
							  'title': 'Approved',
							  'class': ' label-light-success',
							},
							2: {
							  'title': 'Refused',
							  'class': ' label-light-danger',
							},
						  };

						// output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.status + '</div>';
						return '<span class="label font-weight-bold label-lg ' + status[row.status].class + ' label-inline">' + status[row.status].title + '</span>'
					}
				},					
				{
					field: 'date',
					title: 'Date Added',
					type: 'date',
					format: 'MM/DD/YYYY',
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder text-primary mb-0">' + row.date + '</div>';
		
						return output;
					},
				}, 
				],
		});
		
		$('#kt_datatable_search_client_name').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'client_name');
		});

		$('#kt_datatable_search_type').selectpicker();
	};

	return {
		// public functions
		init: function() {
			_demo();
		},
	};
}();

jQuery(document).ready(function() {
	KTAppsUsersListDatatable.init();
});
 
