"use strict";
// Class definition

var KTAppsUsersListDatatable = function() {
	// Private functions
   //var dataJSONArray = JSON.parse();
		//console.log(dataJSONArray);
	// basic demo
	var _demo = function() {
		var datatable = $('#kt_datatable').KTDatatable({
			// datasource definition
			data: {
				type: 'remote',
				//source: dataJSONArray,
				source: {
					read: {
						url: 'ajax/payment_report_ajax.php',
					},
				},
				pageSize: 10, // display 20 records per page
				serverPaging: true,
				//serverFiltering: true,
				//serverSorting: true,
			},
	
			// layout definition
			layout: {
				scroll: false, // enable/disable datatable scroll both horizontal and vertical when needed.
				footer: false, // display/hide footer
			},

			// column sorting
			sortable: true,

			pagination: true,

			search: {
				input: $('#kt_datatable_search_query'),
				//delay: 400,
				key: 'generalSearch'
			},
			
			

			// columns definition
			columns: [
				{
					field: 'sno',
					title: '#',
					sortable: 'asc',
					width: 15,
					type: 'number',
					selector: false,
					textAlign: 'left',
					template: function(data) {
						return '<span class="font-weight-bolder">' + data.sno + '</span>';
					}
				}, {
					field: 'client',
					title: 'Client Name',
					width: 100,
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.client + '</div>';
						
						return output;
					}
				}, {
					field: 'order_id',
					title: 'Order ID',
					sortable: 'asc',
					width: 50,
					type: 'number',
					selector: false,
					textAlign: 'left',
					template: function(data) {
						return '<span class="font-weight-bolder">' + data.order_id + '</span>';
					}
				},{
					field: 'payment_number',
					title: 'Payment Number',
					sortable: 'asc',
					width: 80,
					selector: false,
					textAlign: 'left',
					template: function(data) {
						return '<span class="font-weight-bolder">' + data.payment_number + '</span>';
					}
				},{
					field: 'value',
					title: 'Value',
					sortable: 'asc',
					width: 60,
					type: 'number',
					selector: false,
					textAlign: 'left',
					template: function(data) {
						return '<span class="font-weight-bolder">' + data.value + '</span>';
					}
				}, {
					field: 'type',
					title: 'Type',
					width: 50,
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.type + '</div>';
						
						return output;
					}
				}, {
					field: 'result',
					title: 'Result',
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.result + '</div>';
						
						return output;
					}
				},{
					field: 'mobile',
					title: 'Mobile Type',
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.mobile + '</div>';
						
						return output;
					}
				},				
				{
					field: 'date',
					title: 'Date Added',
					type: 'date',
					format: 'MM/DD/YYYY',
					template: function(row) {
						var output = '';

						// var status = {
						// 	1: {'title': 'Paid', 'class': ' label-light-primary'},
						// 	2: {'title': 'Approved', 'class': ' label-light-danger'},
						// 	3: {'title': 'Pending', 'class': ' label-light-primary'},
						// 	4: {'title': 'Rejected', 'class': ' label-light-success'},
						// };
						// var index = KTUtil.getRandomInt(1, 4);

						output += '<div class="font-weight-bolder text-primary mb-0">' + row.date + '</div>';
						//output += '<div class="text-muted">' + status[index].title + '</div>';

						return output;
					},
				}, 

				],
		});
		
		/* $('#kt_datatable_search_query').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'search');
		}) */;

		$('#kt_datatable_search_type').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'client');
		});



		// $('#kt_datatable_search_type').selectpicker();
	};

	return {
		// public functions
		init: function() {
			_demo();
		},
	};
}();

jQuery(document).ready(function() {
	KTAppsUsersListDatatable.init();
});

$(document).on('click', '#rest_delete', function() {
	var t = $(this);
	Swal.fire({
				text: "Are You Sure Want to Delete!.",
				icon: "success",
				showCancelButton: true,
				buttonsStyling: false,
				confirmButtonText: "Yes, delete!",
				cancelButtonText: "No, cancel",
				customClass: {
					confirmButton: "btn font-weight-bold btn-primary",
					cancelButton: "btn font-weight-bold btn-default"
				}
			}).then(function (result) {
				if (result.value) {
					var x = t.attr('del_id');
					var e = "user_delete=" + x +"&action=delete";
					$.ajax({
							type: "POST",
							url: "ajax/delete_user_ajax.php",
							data: e,
							cache: !1,
							success: function (e){
								window.location.reload();
							}
						})	
				} else if (result.dismiss === 'cancel') {
					// Swal.fire({
					// 	text: "Your form has not been submitted!.",
					// 	icon: "error",
					// 	buttonsStyling: false,
					// 	confirmButtonText: "Ok, got it!",
					// 	customClass: {
					// 		confirmButton: "btn font-weight-bold btn-primary",
					// 	}
					// });
					return false;
				}
			}); 
	});