/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
var __webpack_exports__ = {};
/*!*****************************************************!*\
  !*** ../demo8/src/js/pages/custom/user/add-user.js ***!
  \*****************************************************/


// Class Definition
var KTAddUser = function () {
	// Private Variables
	var _wizardEl;
	var _formEl;
	var _wizardObj;
	var _avatar;
	var _validations = [];

	// Private Functions
	var _initWizard = function () {
		// Initialize form wizard
		_wizardObj = new KTWizard(_wizardEl, {
			startStep: 1, // initial active step number
			clickableSteps: false  // allow step clicking
		});

		// Validation before going to next page
		_wizardObj.on('change', function (wizard) {
			if (wizard.getStep() > wizard.getNewStep()) {
				return; // Skip if stepped back
			}

			// Validate form before change wizard step
			var validator = _validations[wizard.getStep() - 1]; // get validator for currnt step

			if (validator) {
				validator.validate().then(function (status) {
					if (status == 'Valid') {
						// wizard.goTo(wizard.getNewStep());
						$(document).on('click', '.addpage', function() {
							// Submit event
							// _wizardObj.on('submit', function (wizard) {
								Swal.fire({
									text: "All is good! Please wait while the Name is checked.",
									icon: "info",
									showCancelButton: true,
									buttonsStyling: false,
									confirmButtonText: "Yes, submit!",
									cancelButtonText: "No, cancel",
									customClass: {
										confirmButton: "btn font-weight-bold btn-primary",
										cancelButton: "btn font-weight-bold btn-default"
									} 
								}).then(function (result) {
									if (result.value) {
										// $.ajax({
										// 	url: "ajax/edit_user_ajax.php",
										// 	type: 'POST',
										// 	data: $("#kt_form").serialize(), 
										// 	success: function(data){
										// 	   window.location = "?page=users_view";
											   	
										// 	}
								   		// 	}); 
										   ajaxfunction();
										   
									} else if (result.dismiss === 'cancel') {
										Swal.fire({
											text: "Your form has not been submitted!.",
											icon: "error",
											buttonsStyling: false,
											confirmButtonText: "Ok, got it!",
											customClass: {
												confirmButton: "btn font-weight-bold btn-primary",
											}
										});
									}
								});
							// });
						});
						// KTUtil.scrollTop();
					} else {
						Swal.fire({
							text: "Sorry, looks like there are some errors detected, please try again.",
							icon: "error",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn font-weight-bold btn-light"
							}
						}).then(function () {
							KTUtil.scrollTop();
						});
					}
				});
			}

			return false;  // Do not change wizard step, further action will be handled by he validator
		});

		// Change event
		_wizardObj.on('changed', function (wizard) {
			KTUtil.scrollTop();
		});
	
	}

	var _initValidations = function () {
		// Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/

		// Validation Rules For Step 1
		_validations.push(FormValidation.formValidation(
			_formEl,
			{
				fields: {
					name: {
						validators: {
							notEmpty: {
								message: 'Section is required'
							}
						}
					},
					password: {
						validators: {
							notEmpty: {
								message: 'This value is required'
							}
						}
					},
					phone: {
						validators: {
							notEmpty: {
								message: 'This value is required'
							}
						}
					},
					email: {
						validators: {
							notEmpty: {
								message: 'Email is required'
							},
							emailAddress: {
								message: 'The value is not a valid email address'
							}
						}
					},
					user_type: {
						validators: {
							notEmpty: {
								message: 'This value is required'
							}
						}
					},
					restaurant_id: {
						validators: {
							notEmpty: {
								message: 'This value is required'
							}
						}
					},
					branch_id: {
						validators: {
							notEmpty: {
								message: 'This value is required'
							}
						}
					},
				},
				plugins: {
					trigger: new FormValidation.plugins.Trigger(),
					// Bootstrap Framework Integration
					bootstrap: new FormValidation.plugins.Bootstrap({
						//eleInvalidClass: '',
						eleValidClass: '',
					})
				}
			}
		));




	}

	var _initAvatar = function () {
		_avatar = new KTImageInput('kt_user_add_avatar');
	}

	return {
		// public functions
		init: function () {
			_wizardEl = KTUtil.getById('kt_wizard');
			_formEl = KTUtil.getById('kt_form');

			_initWizard();
			_initValidations();
			_initAvatar();
		}
	};
}();


function ajaxfunction(){
	var myFormData = document.getElementById("kt_form");
	var ajax = new XMLHttpRequest();
	ajax.onreadystatechange = function(e){
		if(this.readyState == 4 && this.status == 200){
			var data = this.responseText;
			
			var response = JSON.parse(data);
			

			if(response['status'] == '1'){
			window.location.href = "?page=users_view";
			
			} else {
				swal.fire({
					text: response['message'],
					icon: "error",
					buttonsStyling: false,
					confirmButtonText: "Ok, got it!",
					customClass: {
						confirmButton: "btn font-weight-bold btn-light-primary"
					}
				}).then(function() {
					KTUtil.scrollTop();
				});
			}		
		} 
	}
	ajax.open("POST","ajax/edit_user_ajax.php");
	ajax.send(new FormData(myFormData));
	e.preventDefault();
}

jQuery(document).ready(function () {
	KTAddUser.init();
});

/******/ })()
;
//# sourceMappingURL=add-user.js.map

$("#user_type").change(function () {
	var utype = $(this).val();
	if (utype == 1) {
		$("#shops_div").show();
		$('#branch_div').css('display', 'none');

	} else if (utype == 2) {
		$("#shops_div").show();
		$("#branch_div").show();
	} else if(utype == 0) {
		$('#shops_div').css('display', 'none');
		$('#branch_div').css('display', 'none');


	}
});

$("#restaurant_id").on("change", function () {
	var e = "get_branchs_by_restaurant_id=" + $(this).val();
	$.ajax({
		type: "POST",
		url: "ajax/get_branches_ajax.php",
		data: e,
		cache: !1,
		success: function (e) {
			$("#branches").html(e)
		}
	})
})