"use strict";
// Class definition

var KTAppsUsersListDatatable = function() {
	// Private functions
   //var dataJSONArray = JSON.parse();
		//console.log(dataJSONArray);
	// basic demo
	var _demo = function() {
		var datatable = $('#kt_datatable').KTDatatable({
			// datasource definition
			data: {
				type: 'remote',
				//source: dataJSONArray,
				source: {
					read: {
						url: 'ajax/users_view_ajax.php',
					},
				},
				pageSize: 10, // display 20 records per page
				serverPaging: true,
				//serverFiltering: true,
				//serverSorting: true,
			},
	
			// layout definition
			layout: {
				scroll: false, // enable/disable datatable scroll both horizontal and vertical when needed.
				footer: false, // display/hide footer
			},

			// column sorting
			sortable: true,

			pagination: true,

			search: {
				input: $('#kt_datatable_search_query'),
				//delay: 400,
				key: 'generalSearch'
			},
			
			

			// columns definition
			columns: [
				{
					field: 'RecordID',
					title: '#',
					sortable: 'asc',
					width: 20,
					type: 'number',
					selector: false,
					textAlign: 'left',
					template: function(data) {
						return '<span class="font-weight-bolder">' + data.RecordID + '</span>';
					}
				},{
					field: 'user_id',
					title: 'User ID',
					sortable: 'asc',
					width: 40,
					type: 'number',
					selector: false,
					textAlign: 'left',
					template: function(data) {
						return '<span class="font-weight-bolder">' + data.user_id + '</span>';
					}
				}, {
					field: '',
					title: 'Name',
					width: 150,
					template: function(data) {
						// var number = KTUtil.getRandomInt(1, 14);
						// var user_image = '100_' + number + '.jpg';

						var output = '';
						// var file = 'system/assets/media/users/' + data.RecordID + '/'+ data.image;
						// var checkexist = checkFileExist(file);
						if (data.image) {
							output = '<div class="d-flex align-items-center">\
								<div class="symbol symbol-40 symbol-sm flex-shrink-0">\
									<img class="" src="assets/media/users/' + data.user_id + '/'+ data.image +'" alt="photo">\
								</div>\
								<div class="ml-4">\
									<div class="text-dark-75 font-weight-bolder font-size-lg mb-0">' + data.Name + '</div>\
									<a href="tel:' + data.Phone + '" class="text-muted font-weight-bold text-hover-primary">' + data.Phone + '</a>\
								</div>\
							</div>';
						}
						else {
							var stateNo = KTUtil.getRandomInt(0, 7);
							var states = [
								'success',
								'primary',
								'danger',
								'success',
								'warning',
								'dark',
								'primary',
								'info'];
							var state = states[stateNo];

							output = '<div class="d-flex align-items-center">\
								<div class="symbol symbol-40 symbol-light-'+state+' flex-shrink-0">\
									<span class="symbol-label font-size-h4 font-weight-bold">' + data.Name.substring(0, 1) + '</span>\
								</div>\
								<div class="ml-4">\
									<div class="text-dark-75 font-weight-bolder font-size-lg mb-0">' + data.Name + '</div>\
									<a href="#" class="text-muted font-weight-bold text-hover-primary">' + data.Phone + '</a>\
								</div>\
							</div>';
						}

						return output;
					}
				}, {
					field: 'Email',
					title: 'Email',
					width: 250,
					template: function(row) {
						var output = '';

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + row.Email + '</div>';
						return output;
					}
				},

				{
					field: 'Membership',
					title: 'Membership Type',
					template: function(row) {
						var output = '';

						var mNo = row.Membership;
							var mship = [
								'General Manager',
								'Restaurant Manager',
								'Branch Manager',
								'Admin'];
							var memberShip = mship[mNo];

						output += '<div class="font-weight-bolder font-size-lg mb-0">' + memberShip + '</div>';
						return output;
					}
				},				
				{
					field: 'Date',
					title: 'Date Added',
					type: 'date',
					format: 'MM/DD/YYYY',
					template: function(row) {
						var output = '';

						// var status = {
						// 	1: {'title': 'Paid', 'class': ' label-light-primary'},
						// 	2: {'title': 'Approved', 'class': ' label-light-danger'},
						// 	3: {'title': 'Pending', 'class': ' label-light-primary'},
						// 	4: {'title': 'Rejected', 'class': ' label-light-success'},
						// };
						// var index = KTUtil.getRandomInt(1, 4);

						output += '<div class="font-weight-bolder text-primary mb-0">' + row.Date + '</div>';
						//output += '<div class="text-muted">' + status[index].title + '</div>';

						return output;
					},
				}, 

				{
					field: 'Actions',
					title: 'Actions',
					sortable: false,
					width: 100,
					overflow: 'visible',
					autoHide: false,
					template: function(row) {
						return '\
	                        <a href="?page=users_edit&id='+ btoa(row.user_id) +'" class="btn btn-sm btn-clean btn-icon mr-2" title="Edit details">\
	                            <span class="svg-icon svg-icon-md">\
	                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">\
	                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">\
	                                        <rect x="0" y="0" width="24" height="24"/>\
	                                        <path d="M8,17.9148182 L8,5.96685884 C8,5.56391781 8.16211443,5.17792052 8.44982609,4.89581508 L10.965708,2.42895648 C11.5426798,1.86322723 12.4640974,1.85620921 13.0496196,2.41308426 L15.5337377,4.77566479 C15.8314604,5.0588212 16,5.45170806 16,5.86258077 L16,17.9148182 C16,18.7432453 15.3284271,19.4148182 14.5,19.4148182 L9.5,19.4148182 C8.67157288,19.4148182 8,18.7432453 8,17.9148182 Z" fill="#000000" fill-rule="nonzero"\ transform="translate(12.000000, 10.707409) rotate(-135.000000) translate(-12.000000, -10.707409) "/>\
	                                        <rect fill="#000000" opacity="0.3" x="5" y="20" width="15" height="2" rx="1"/>\
	                                    </g>\
	                                </svg>\
	                            </span>\
	                        </a>\
	                        <a id="rest_delete" del_id="'+ row.user_id +'" class="btn btn-sm btn-clean btn-icon" title="Delete">\
	                            <span class="svg-icon svg-icon-md">\
	                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">\
	                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">\
	                                        <rect x="0" y="0" width="24" height="24"/>\
	                                        <path d="M6,8 L6,20.5 C6,21.3284271 6.67157288,22 7.5,22 L16.5,22 C17.3284271,22 18,21.3284271 18,20.5 L18,8 L6,8 Z" fill="#000000" fill-rule="nonzero"/>\
	                                        <path d="M14,4.5 L14,4 C14,3.44771525 13.5522847,3 13,3 L11,3 C10.4477153,3 10,3.44771525 10,4 L10,4.5 L5.5,4.5 C5.22385763,4.5 5,4.72385763 5,5 L5,5.5 C5,5.77614237 5.22385763,6 5.5,6 L18.5,6 C18.7761424,6 19,5.77614237 19,5.5 L19,5 C19,4.72385763 18.7761424,4.5 18.5,4.5 L14,4.5 Z" fill="#000000" opacity="0.3"/>\
	                                    </g>\
	                                </svg>\
	                            </span>\
	                        </a>\
						';
					},
				}],
		});
		
		/* $('#kt_datatable_search_query').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'search');
		}) */;

		$('#kt_datatable_search_type').on('change', function() {
			datatable.search($(this).val().toLowerCase(), 'Type');
		});



		$('#kt_datatable_search_type').selectpicker();
	};

	return {
		// public functions
		init: function() {
			_demo();
		},
	};
}();

jQuery(document).ready(function() {
	KTAppsUsersListDatatable.init();
});

$(document).on('click', '#rest_delete', function() {
	var t = $(this);
	Swal.fire({
				text: "Are You Sure Want to Delete!.",
				icon: "success",
				showCancelButton: true,
				buttonsStyling: false,
				confirmButtonText: "Yes, delete!",
				cancelButtonText: "No, cancel",
				customClass: {
					confirmButton: "btn font-weight-bold btn-primary",
					cancelButton: "btn font-weight-bold btn-default"
				}
			}).then(function (result) {
				if (result.value) {
					var x = t.attr('del_id');
					var e = "user_delete=" + x +"&action=delete";
					$.ajax({
							type: "POST",
							url: "ajax/delete_user_ajax.php",
							data: e,
							cache: !1,
							success: function (e){
								window.location.reload();
							}
						})	
				} else if (result.dismiss === 'cancel') {
					// Swal.fire({
					// 	text: "Your form has not been submitted!.",
					// 	icon: "error",
					// 	buttonsStyling: false,
					// 	confirmButtonText: "Ok, got it!",
					// 	customClass: {
					// 		confirmButton: "btn font-weight-bold btn-primary",
					// 	}
					// });
					return false;
				}
			}); 
	});

// 	function checkFileExist(urlToFile) {
// 		var xhr = new XMLHttpRequest();
// 		xhr.open('HEAD', urlToFile, false);
// 		xhr.send();
		 
// 		if (xhr.status == "404") {
// 			return false;
// 		} else {
// 			return true;
// 		}
// 	}

	
// $(window).error(function(){
// 	return true;
//   });
  
	 